Kerkerkruip Systems by Victor Gijsbers begins here.




Volume - Systems

Test object is an object that varies.


Part - Properties of rooms

[Standard set of properties:
X is connectable.
X is not connection-inviting.
X is placeable.
X is habitable.
X is treasurable.
X is vp-agnostic.
X is not consecrated.
X is civilised/religious/barren/deathly/elemental/magical/alchemical]


Section - Placement properties

A room can be connectable or not connectable. A room is usually connectable. [Additional connections can be made in the last stage of making the map.]

A room can be connection-inviting or not connection-inviting. A room is usually not connection-inviting. [If connection-inviting (and connectable), all possible connections to this room will be made.]

A room can be placeable or not placeable. A room is usually placeable. [Not placeable rooms are not considered during the normal dungeon creation.]

A room can be habitable or not habitable. A room is usually habitable. [Monsters can be placed in it.]

A room can be treasurable or not treasurable. A room is usually treasurable. [Treasures can be placed in it.]


Section - Vertical placement

[This section defines properties of rooms that affect how deep in the dungeon they are placed. It also contains the necessary rules for doing this.]

[vp-agnostic: standard
vp-underground: only underground
vp-likely-underground: probably underground
vp-above-ground: only above ground (z =>0)
vp-high: only above ground level (z>0)
vp-likely-high: more likely above ground]

Vertical placement is a kind of value. The vertical placements are vp-agnostic, vp-underground, vp-likely-underground, vp-above-ground, vp-high, and vp-likely-high.

A room has a vertical placement. The vertical placement of a room is usually vp-agnostic.

[A room can be underground or not underground. A room is usually not underground. [Underground rooms can only be placed underground, and are more likely than other rooms to be placed so.]]

A placement possible rule (this is the vertical placement possible rule):
	if considered room is vp-underground:
		if the considered-z is not less than 0:
			rule fails;
	if considered room is vp-above-ground:
		if the considered-z is less than 0:
			rule fails;
	if considered room is vp-high:
		if the considered-z is not greater than 0:
			rule fails.

A placement scoring rule (this is the vertical placement scoring rule):
	if considered room is vp-underground or considered room is vp-likely-underground:
		if the considered-z is less than 0:
			increase current room score by 0 - considered-z;
	if considered room is vp-high or considered room is vp-likely-high:
		if the considered-z is greater than 0:
			increase current room score by considered-z.
			
Section - Mood

[Mood is used during generation of the dungeon. Rooms with the same mood are more often placed together, and treasures are often placed in a room with fits their mood.]

Mood is a kind of value. The moods are civilised, religious, barren, deathly, elemental, magical, alchemical and non-mood.
A room has a mood. The mood of a room is usually barren.

A placement scoring rule (this is the link rooms with the same mood rule):
	if the mood of considered room is the mood of original room:
		[say "([considered room] has same mood as [original room])";]
		increase current room score by 2.

Section - Consecration

[Temples should be consecrated. Some powers -- such as extra praying abilities -- will only work in non-consecrated rooms.]

A room is either consecrated or not consecrated. A room is usually not consecrated.



Section - Collapse

First carry out going (this is the collapse rule):
	if the room noun of location collapses location:
		let X be room noun of location;
		change the noun exit of location to nothing;
		let reverse be the opposite of noun;
		change the reverse exit of X to nothing;
		say "With a huge crash, the [if noun is up or noun is down]staircase[otherwise]corridor[end if] [bold type]collapses[roman type] behind you!";
		[wait 4000 milliseconds before continuing;]
		now the retreat location is X;
		now X does not collapse location;
		now location does not collapse X.


Section - Digging and extra rooms

Digging is an action applying to one object.
Understand "dig [direction]" as digging.

Check digging (this is the dig in a direct rule):
	if noun is not a cardinal direction:
		say "You can only dig north, south, west, east, up, or down." instead.

A thing is either a digging tool or not a digging tool. A thing is usually not a digging tool.

Check digging (this is the can only dig when carrying a digging tool rule):
	unless the player has a digging tool:
		say "You need a suitable tool to dig." instead.

Check digging (this is the only dig in connectable rooms rule):
	unless location is connectable:
		say "A magical force prevents you from digging." instead.

Tunnel is a kind of room. "A fairly nondescript tunnel." A tunnel is not placeable. There is 25 tunnels.

[Note: we cannot use Dynamic Objects to create new tunnels without disabling fast route finding. (Fast route finding uses a table of rooms, and fails messily when we add new rooms to the game.) So I'm just starting out with 25 tunnels. We don't want the player to dig hundreds of tunnels anyway.]

Carry out digging:
	let x be the x noun of location;
	let y be the y noun of location;
	let z be the z noun of location;
	if the space at x by y by z is free:
		if there is at least one not placed tunnel:
			let item be a random not placed tunnel;
			place item from location at x by y by z;
			say "You magically create a tunnel [noun].";
			do the dig move;
		otherwise:
			say "The laws of this place prevent further digging.";
	otherwise:
		let item be the room at x by y by z;
		if item is the room noun from the location: 
			say "There already is a passage there.";
		otherwise:
			if item is connectable:
				change the noun exit of the location to item; 
    				let reverse be the opposite of noun; 
    				change the reverse exit of item to the location;
				say "You magically create a tunnel [noun].";
				do the dig move;
			otherwise:
				say "A magical force prevents you from digging.".

To do the dig move:
	if hate is present:
		now the player is runner;
		repeat with X running through alive persons in the location:
			now X does not press the player;
			now the player does not press X;
			if the player is alive:
				if the faction of X hates the faction of the player:
					make X strike a blow against the player;
			now concentration of X is 0;
	if the player is alive:
		let place be the room noun of location;
		now retreat location is location;
		move the player to place;
		now the take no time boolean is false.

Last carry out looking when the location is a tunnel (this is the hint about other rooms rule):
	let K be a list of directions;
	let m be 0;
	repeat with way running through cardinal directions:
[		say "testing [way] ";]
		let x be the x way of location;
		let y be the y way of location;
		let z be the z way of location;
		if not the space at x by y by z is free:
			let place be room at x by y by z;
[			say "[place] is [way] of [location] ";]
			unless place is the room way from location:
				unless place is a tunnel:
					increase m by 1;
					add way to K;
	if m is greater than 0:
		say "There seems to be somewhat different stone [K].".

Section - Collapsing passages

Collapsing is an action applying to one object.
Understand "collapse [direction]" as collapsing.

Check collapsing (this is the collapse in a direct rule):
	if noun is not a cardinal direction:
		say "You can only collapse a passage to the north, south, west, east, up, or down." instead.

A thing is either a collapsing tool or not a collapsing tool. A thing is usually not a collapsing tool.

Check collapsing (this is the can only collapse when carrying a collapsing tool rule):
	unless the player has a collapsing tool:
		say "You need a suitable tool to collapse passages." instead.

Check collapsing:
	let place be the room noun from location;
	unless place is a room:
		take no time;
		say "There is no passage there to collapse.".

Carry out collapsing:
	let place be room noun of location;
	change the noun exit of location to nothing;
	let reverse be the opposite of noun;
	change the reverse exit of place to nothing;
	say "With a huge crash, the [if noun is up or noun is down]staircase[otherwise]corridor[end if] collapses!".


Book - Monsters

A monster is usually hostile.
A monster is usually neuter.




Chapter - Emotionless

[Some persons have no emotions, and are immune to, for instance, being dominated.]

A person is either emotionless or not emotionless. A person is usually not emotionless.


Chapter - Non-attacker

[Has no influence on the AI (which you will want to customise anyway), but ensures that the person strikes no blow against the player when the player is retreating / running.]

A person can be non-attacker. A person is usually not non-attacker.


Chapter - Weapon user

[Weapon users can ready new weapons.]

A person is either weapon user or not weapon user. A person is usually not weapon user.

A standard AI action select rule (this is the non weapon users never ready rule):
	if the global attacker is not weapon user:
		choose row with an Option of the action of the global attacker readying the stored_weapon in the Table of AI Combat Options;
		decrease the Weight entry by 1000.



Chapter - Size

Size is a kind of value. The sizes are tiny, small, medium, large, huge and gargantuan.

A person has a size. A person is usually medium.


Chapter - Powers

A power is a kind of thing.

A power is either granted or not granted. A power is usually not granted.
A power has a number called the power level. The power level of a power is usually 1.

Granting relates one monster to one power. The verb to grant (he grants, they grant, he granted, it is granted, he is granting) implies the granting relation.

Last aftereffects rule (this is the grant powers when a monster is slain rule):
	if the global attacker is the player:
		if global defender is not alive:
			do the absorption with global defender.

Every turn (this is the remove all killed monsters from play rule):
	repeat with guy running through killed not off-stage persons:
		unless guy is the player:
			do the absorption with guy.

To do the absorption with (guy - a person):
	increase score by level of guy;
	now test subject is guy;
	unless absorption is stopped:
		do power transferral with the guy;
		heal fully because the guy is slain;
	have the guy disappear;
	do achievement awarding for the guy.

To do power transferral with (guy - a person):
	repeat with X running through powers:
		if guy grants X:
			follow the absorbing rules for X;
			now X is granted;
			let n be the power level of X;
			let Z be a list of powers;
			repeat with Y running through granted powers:
				unless X is Y:
					unless power level of Y is greater than the power level of X:
						add Y to Z;
						follow the repelling rules for Y;
						now Y is not granted;
			if the number of entries in Z is greater than 0:
				say "The violence of the absorption drives [Z with definite articles] out of your body. ";.

To heal fully because (guy - a person) is slain:
	if the level of guy is greater than 0 and the level of guy is not 10:
		unless the player is undead:
			say "Absorbing a soul has fully healed you.[paragraph break]";
			fully heal the player;
		otherwise:
			say "Absorbing a soul has restored some of your health.[paragraph break]";
			let n be 8 times level of guy;
			heal the player for n health;
	if the level of guy is 10:
		do the level 10 victory with guy.

To have (guy - a person) disappear:
	let X be the holder of guy;
	unless X is nothing:
		repeat with Y running through things had by guy:
			move Y to X;
			if Y is a weapon:
				now Y is not readied;
	remove guy from play.

To do achievement awarding for (guy - a person):
	if level of guy is 1:
		award achievement assistant dungeoneer;
	if level of guy is 2:
		award achievement adventurer;
	if level of guy is 3:
		award achievement hunter;
	if level of guy is 4:
		award achievement destroyer.


Absorbing is a power based rulebook.
Repelling is a power based rulebook.

Section - Greatest power of the player

To decide which number is the greatest power of the player:
	let m be 0;
	if at least one power is granted:
		repeat with X running through granted powers:
			if power level of X is greater than m:
				now m is power level of X;
	decide on m.

Section - Whether absorption is stopped

The absorption stopping rules are a rulebook.

To decide whether absorption is stopped:
	consider the absorption stopping rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.




Chapter - Flying

[Some persons have flight, which makes them immune to some effects.]

A person can be flyer or not flyer. A person is usually not flyer.

The flying rules are a rulebook.

To decide whether (guy - a person) is flying:
	now test subject is guy;
	consider the flying rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.

A flying rule (this is the flyers fly rule):
	if test subject is flyer:
		rule succeeds.

Status rule (this is the flying status rule):
	if player is flying:
		say "You are [bold type]flying[roman type].[line break][run paragraph on]".



Chapter - Blindness

A person can be blinded or not blinded. A person is usually not blinded. [Blinded is a property that makes you blind. It can be cured.]

A person can be eyeless or not eyeless. A person is usually not eyeless. [An eyeless person is blind but not negatively affected by blindness.]

The blindness rules are a rulebook.

To decide whether (guy - a person) is blind:
	now test subject is guy;
	consider the blindness rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.

A blindness rule (this is the blind if blinded rule):
	if test subject is blinded:
		rule succeeds.

A blindness rule (this is the blind if eyeless rule):
	if test subject is eyeless:
		rule succeeds.
		
Status rule (this is the blindness status rule):
	if player is blind:
		say "You are [bold type]blind[roman type].[line break][run paragraph on]".

An attack modifiers rule (this is the blindness attack modifier rule):
	if the global attacker is blind and the global attacker is not eyeless:
		say " - 3 (blindness)[run paragraph on]";
		decrease the to-hit modifier by 3.

An attack modifiers rule (this is the blindness defence modifier rule):
	if the global defender is blind and the global defender is not eyeless:
		say " + 2 (defender blind)[run paragraph on]";
		increase the to-hit modifier by 2.

Chance to win rule (this is the CTW blindness bonus rule):
	if the global attacker is blind and the global attacker is not eyeless:
		decrease the chance-to-win by 3;
	if the global defender is blind and the global defender is not eyeless:
		increase the chance-to-win by 2.

A perception test rule (this is the blindness affects perception rule):
	if the test subject is blind and the test subject is not eyeless:
		decrease test score by 3;
		say " - 3 (blindness)[run paragraph on]".


Chapter - Healing

[This is an action that monsters can take.]

Healing is an action applying to nothing. [Obviously, it will apply to someone, but our simple AI cannot handle it that way.]

A person has a number called the heal power. The heal power of a person is usually 0.
A person has a number called the heal cooldown. The heal cooldown of a person is usually 3.
A person has a number called the current heal cooldown. The current heal cooldown of a person is usually 0.

First standard AI action select rule (this is the consider healing rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker healing;
	change the Weight entry to -1000.
		
Standard AI action select rule (this is the only healers consider healing rule):
	choose row with an Option of the action of the global attacker healing in the Table of AI Combat Options;
	if the heal power of the global attacker is greater than 0 and the current heal cooldown of the global attacker is less than 1:
		change the Weight entry to 5.
			
Standard AI action select rule (this is the only heal when someone has damage rule):
	if the heal power of the global attacker is greater than 0:
		choose row with an Option of the action of the global attacker healing in the Table of AI Combat Options;
		let P be false;
		let m be 0;
		repeat with guy running through alive persons enclosed by the location:
			if the faction of guy does not hate the faction of the global attacker and guy is not the global attacker:
				let n be permanent health of guy minus health of guy; 
				if n is greater than 0:
					now P is true;
					if m is less than n, now m is n; [at this stage, m becomes the greatest damage any of the global attacker's allies has]
		if P is false:
			decrease the Weight entry by 1000;
		otherwise:
			if m is greater than heal power of the global attacker, now m is heal power of the global attacker; [now m becomes the maximum amount of damage the global attacker can heal]
			increase Weight entry by m.

Carry out an actor healing:
	let m be 0;
	let chosen one be the actor;
	repeat with guy running through alive persons enclosed by the location:
		if the faction of guy does not hate the faction of the actor and guy is not the actor:
			let n be permanent health of guy minus health of guy; 
			if n is greater than 0:
				if m is less than n:
					now chosen one is guy;
					now m is n;
	if m is greater than heal power of the actor, now m is heal power of the actor;
	say "[The actor] casts a spell of magical healing on [the chosen one], removing [m] points of damage.";
	heal chosen one for m health;
	now current heal cooldown of the actor is heal cooldown of the actor. 

Every turn (this is the reduce heal cooldown of the main actor rule):
	if the current heal cooldown of the main actor is greater than 0:
		decrease the current heal cooldown of the main actor by 1.


Chapter - Teleportation

[As a monster action.]

Teleporting is an action applying to nothing.

A person has a number called the teleport amount. The teleport amount of a person is usually 0. [Number of times the monster can teleport. -1 means infinitely.]
A person has a number called the teleport eagerness. The teleport eagerness of a person is usually 10. [percentage chance of serious consideration]
A person is either spontaneous teleporter or not spontaneous teleporter. A person is usually not spontaneous teleporter. [A spontaneous teleporter will also teleport when the player is not present. Best used with a teleport amount of -1.]

A room can be teleportable or not teleportable. A room is usually teleportable. [A teleportable room is one you can teleport TO.]

[We have teleport rules which check whether a person can teleport.]
The teleport impossible rules are a rulebook.

To decide whether teleportation is impossible for (guy - a person):
	now test subject is guy;
	consider the teleport impossible rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.

[Finally, it need not be obvious to a person that teleportation is impossible. If a person is a teleport impossible aware, he does.]

A person is either teleport impossible aware or not teleport impossible aware. A person is usually not teleport impossible aware.

[AI rules]

First standard AI action select rule (this is the consider teleporting rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker teleporting;
	if the teleport amount of the global attacker is 0 or the combat state of the global attacker is not at-Act:
		change the Weight entry to -1000;
	otherwise:
		if the global attacker is teleport impossible aware:
			change the Weight entry to -100;
		otherwise:
			change the Weight entry to -20.

Standard AI action select rule (this is the teleport eagerness rule):
	choose row with an Option of the action of the global attacker teleporting in the Table of AI Combat Options;
	let n be the teleport eagerness of the global attacker;
	if a random chance of n in 100 succeeds:
		increase the Weight entry by 35.

Every turn (this is the spontaneous teleport rule):
	repeat with guy running through spontaneous teleporter not off-stage persons:
		if teleport amount of guy is not 0:
			let n be the teleport eagerness of guy;
			if a random chance of n in 100 succeeds:
				try guy teleporting. 

Check an actor teleporting (this is the teleport impossible rule):
	if teleportation is impossible for the actor:
		now the actor is teleport impossible aware;
		now global actor is the actor;
		say "[CAP-actor] tries to teleport away, but something makes this impossible!" instead.

Carry out an actor teleporting (this is the standard monster teleport rule):
	let destination be a random placed placeable teleportable room;
	while destination is the location of the actor:
		let destination be a random placed placeable teleportable room;
	let see-arriving be false;
	let see-going be false;
	if location of the actor is the location, now see-going is true;
	if destination is the location, now see-arriving is true;
	move actor to destination;
	now concentration of actor is 0;
	unless teleport amount of actor is -1:
		decrease teleport amount of actor by 1;
	now global actor is the actor;
	if see-going is true:
		say "[CAP-actor] suddenly teleports away!";
	if see-arriving is true:
		say "[CAP-actor] suddenly teleports into the room!".

Every turn (this is the teleport impossible awareness expires rule):
	repeat with guy running through teleport impossible aware persons:
		unless teleportation is impossible for guy:
			now guy is not teleport impossible aware.


Chapter - Ray of disintegration

[Our implementation is simple in the sense that the AI has no preference for destroying one object over another. Making this more interesting would be a good project for the future.]

Disintegrating is an action applying to nothing.

A person has a number called the disintegrate power. The disintegrate power of a person is usually 0.
A person has a number called the disintegrate cooldown. The disintegrate cooldown of a person is usually 5.
A person has a number called the current disintegrate cooldown. The current disintegrate cooldown of a person is usually 0.

First standard AI action select rule (this is the consider disintegrating rule):
	choose a blank Row in the Table of AI Combat Options;
	change the Option entry to the action of the global attacker disintegrating;
	change the Weight entry to -1000.
		
Standard AI action select rule (this is the only disintegraters consider disintegrating rule):
	choose row with an Option of the action of the global attacker disintegrating in the Table of AI Combat Options;
	if the disintegrate power of the global attacker is greater than 0 and the current disintegrate cooldown of the global attacker is less than 1:
		change the Weight entry to disintegrate power of the global attacker;
		if a random chance of 1 in 10 succeeds, increase Weight entry by 10.

Standard AI action select rule (this is the only disintegrate when there are items rule):
	choose row with an Option of the action of the global attacker disintegrating in the Table of AI Combat Options;
	let boolean be false;
	repeat with guy running through alive persons enclosed by the location:
		if the faction of the global attacker hates the faction of guy:
			if guy has at least one[ corruptible] thing:
				now boolean is true;
	if boolean is false:
		change the Weight entry to -1000.

Carry out an actor disintegrating (this is the standard disintegrate rule):
	let boolean be false;
	let guy be the actor;
	let item be the non-thing;
	while boolean is false:
		now guy is a random alive person enclosed by the location;
		if the faction of the global attacker hates the faction of guy:
			if guy has at least one[ corruptible] thing:
				now item is a random[ corruptible] thing had by guy;
				now boolean is true;
	let n be the disintegrate power of the actor;
	if item is minor or item is non-treasure:
		now n is n times 6;
	if item is major:
		now n is n times 4;
	if item is epic:
		now n is n times 2;
	if item is incorruptible:
		now n is 0;
	if a random chance of n in 100 succeeds:
		say "[The actor] casts a ray of disintegration at [the item], destroying the object!";
		remove item from play;
		ready natural weapons;
	otherwise:
		say "[The actor] casts a ray of disintegration at [the item], but the object resists!";
	now current disintegrate cooldown of the actor is disintegrate cooldown of the actor.

Every turn (this is the reduce disintegrate cooldown of the main actor rule):
	if the current disintegrate cooldown of the main actor is greater than 0:
		decrease the current disintegrate cooldown of the main actor by 1.
		


Chapter - Followers

[Followers consider the follower rules. If these do not fail, they attempt to move one room towards the player.]

A person is either follower or not follower. A person is usually not follower.
A person has a number called the follower percentile chance. The follower percentile chance of a person is usually 100.

The followers rules are a rulebook.

Every turn (this is the have followers follow rule):
	if main actor is the player:
		repeat with guy running through alive not off-stage follower persons:
			if the location of guy is not the location of the player:
				now test subject is guy;
				consider the followers rules;
				unless rule failed:
					let the way be the best route from the location of guy to the location of the player;
					if way is a direction, try guy going the way.

A followers rule (this is the follower percentile chance rule):
	let n be the follower percentile chance of the test subject;
	unless a random chance of n in 100 succeeds:
		rule fails.

A followers rule (this is the follower cannot follow hidden person rule):
	if player is hidden and test subject is not unnaturally aware and test subject is not unnaturally aware follower:
		rule fails.


Chapter - New factions - undead and horrors

[Undead attack everyone, except for other undead. Horrors attack everyone.]

undead is a faction.
horrific is a faction.

When play begins (this is the set undead and horror factions rule):
	repeat with X running through factions:
		now horrific hates X;
		now X hates horrific;
		unless X is undead:
			now undead hates X;
			now X hates undead.

[And now some stuff we need because horrors might attack themselves.]

The standard hate rule is not listed in any rulebook.

Hate rule (this is the nonstandard hate rule):
	if the player is friendly and at least one hostile alive person is enclosed by the location:
		if friendly hates hostile:
			rule succeeds; [This is only here for speed. It is the most common case where we decide yes.]
	repeat with X running through alive not passive persons enclosed by the location:
		repeat with Y running through alive persons enclosed by the location:
			if the faction of X hates the faction of Y and X is not Y:
				rule succeeds;
	rule fails.

A standard AI target select rule (this is the do not target yourself rule):
	choose row stored_row in Table of AI Combat Person Options;
	if stored_person is the global attacker, decrease the Weight entry by 2000.	

Status rule (this is the undead status rule):
	if the player is undead:
		say "You are [bold type]undead[roman type]: other undead are your allies; potential living allies are your enemies instead; absorbing a soul may heal you only partially.[line break][run paragraph on]".



Chapter - Ranged weapons

[Some specials should or should not happen for ranged weapons. For instance, a heated ranged weapon does not deal extra damage.]
	
A weapon is either ranged or not ranged. A weapon is usually not ranged.

Chapter - Armour-stoppable

[Armour should only reduce the damage of some weapons. For instance, armour doesn't help against a lightning bolt or dragon's fire.]

A weapon is either armour-stoppable or not armour-stoppable. A weapon is usually armour-stoppable.


Chapter - Materials

[Current design strategy: do not make weapons silver. The player must decide to turn a weapon silver by applying the unguentum argenti.]

Material is a kind of value. The materials are other-material, iron, silver, paper, cloth, wood, glass, leather, flesh, dragon skin and stone. Understand "wooden" as wood.

A thing has a material. The material of a thing is usually other-material.
The material of a person is usually flesh.

Understand the material property as describing a thing.

A thing has a material called the original material.

When play begins (this is the set original material rule):
	repeat with X running through things:
		now the original material of X is the material of X.

Before printing the name of a thing (called item):
	if material of item is not original material of item:
		if material of item is not wood and material of item is not other-material:
			say "[material of item] ";
		otherwise if material of item is wood:
			say "wooden ".


Section - Silver

[Before printing the name of a silver weapon (called item):
	if the original material of item is not silver:
		say "[material of item] ".] [Not needed since above.]

Damage modifiers rule (this is the silver damage rule):
	if the global attacker weapon is silver:
		if the global defender is not undead:
			if the numbers boolean is true, say " - 2 (silver weapon)[run paragraph on]";
			decrease the damage modifier by 2;
		otherwise:
			if the numbers boolean is true, say " + 4 (silver weapon)[run paragraph on]";
			increase the damage modifier by 4.


[Section - Wood

A weapon can be original-wood or not original-wood. A weapon is usually not original-wood.

When play begins:
	repeat with X running through wood weapons:
		now X is original-wood.

Before printing the name of a wood not original-wood weapon (called item):
	say "wooden ".]


Chapter - Doing risky things

[Sometimes, the player can do a risky thing which should allow his enemy to make an attack of opportunity. But we do not want this to be a good way of making your enemy attack before his concentration is high enough -- so we are going to give the enemy a big to-hit bonus when the player is doing something risky.] 

[I don't think we are actually using this right now.]

A person is either risky or not risky. A person is usually not risky.

An attack modifiers rule (this is the defender is doing something risky rule):
	if the global defender is risky:
		if the numbers boolean is true, say " + 6 (defender taking risky action)[run paragraph on]";
		increase the to-hit modifier by 6.

Chance to win rule (this is the CTW risky bonus rule):
	if the global defender is risky:
		increase the chance-to-win by 6.


Chapter - Beloved of Aite

The beloved of Aite rules are a rulebook.

To decide whether (guy - a person) is beloved of Aite:
	now test subject is guy;
	consider the beloved of Aite rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.

A person can be Aite-loved or not Aite-loved. A person is usually not Aite-loved.

A beloved of Aite rule (this is the Aite-loved rule):
	if test subject is Aite-loved:
		rule succeeds.



Chapter - Heat

[The heat system currently supports hotness for things. However, giving a hotness to persons is _not_ truly supported, and will lead to unwanted behaviour.]

[Much of the heat system has been turned off. It was too unituitive and punishing. Perhaps also too computation intensive?]

Section - Basics

A thing has a number called the heat strength. The heat strength of a thing is usually 0.

Definition: a thing is hot if its heat strength is greater than 0. 


Section - Feedback

Not-mentioning-hotness is a truth state that varies. Not-mentioning-hotness is false.
Not-mentioning-flaming is a truth state that varies. Not-mentioning-flaming is false.

To turn off mentioning hotness:
	now not-mentioning-hotness is true;
	now not-mentioning-flaming is true.

To turn on mentioning hotness:
	now not-mentioning-hotness is false;
	now not-mentioning-flaming is false.

Before printing the name of hot not flaming thing (called item):
	unless not-mentioning-hotness is true:
		if heat strength of item is less than 3:
			say "hot [run paragraph on]";
		otherwise if heat strength of item is less than 6:
			say "very hot [run paragraph on]";
		otherwise:
			say "blazingly hot [run paragraph on]".
		
Understand "hot" as a thing when the heat strength of the item described is greater than 0.	
Understand "very hot" as a thing when the heat strength of the item described is greater than 2.
Understand "blazingly" as a thing when the heat strength of the item described is greater than 5.		

Last carry out examining a hot thing:
	now not-mentioning-hotness is true;
	say "[The noun] is ";
	now not-mentioning-hotness is false;	
	if heat strength of noun is less than 3:
		say "hot.";
	otherwise if heat strength of noun is less than 6:
		say "very hot.";
	otherwise:
		say "blazingly hot.".

First attack modifiers rule:
	turn off mentioning hotness.

Last attack modifiers rule:
	turn on mentioning hotness.

First damage modifiers rule:
	turn off mentioning hotness.

Last damage modifiers rule:
	turn on mentioning hotness.


Section - Temperatures and flaming

A material has a number called the destroying heat. The destroying heat of a material is usually 5.
A material is either melter or burner.
A thing is either flaming or not flaming. A thing is usually not flaming.
Understand the flaming property as describing a thing. Understand "burning" as flaming.

The destroying heat of iron is 10. Iron is melter.
The destroying heat of silver is 7. Silver is melter.
The destroying heat of paper is 1. Paper is burner.
The destroying heat of cloth is 1. Cloth is burner.
The destroying heat of wood is 3. Wood is burner.
The destroying heat of leather is 3. Leather is burner.
The destroying heat of flesh is 1. Flesh is burner.
The destroying heat of glass is 6. Glass is melter.
The destroying heat of stone is 15. Stone is melter.
The destroying heat of dragon skin is 25. Dragon skin is burner.

Every turn (this is the flaming items burn away rule):
	repeat with item running through flaming not off-stage things:
		if a random chance of 1 in 4 succeeds or destroying heat of material of item + 2 is not greater than heat strength of item:
			now heat strength of item is 0;
			now item is not flaming;
			turn off mentioning hotness;			
			if item is visible, say "[The item] [if material of item is melter]melts[otherwise if material of item is not flesh]burns[otherwise]chars[end if] away.";
			turn on mentioning hotness;			
			remove the item from play.
			
Before printing the name of a flaming thing (called item):
	unless not-mentioning-flaming is true:
		say "burning [run paragraph on]".

Every turn (this is the heat destroys items rule):
	repeat with item running through hot not flaming not off-stage things:
		let n be heat strength of item;
		let m be destroying heat of the material of item;
		if m is not greater than n:
			if material of item is burner and m + 2 is greater than n:
				now item is flaming;
				turn off mentioning hotness;
				if item is visible, say "[The item] catches fire!";
				turn on mentioning hotness;				
			otherwise:
				turn off mentioning hotness;
				if item is visible, say "[The item] [if material of item is melter]melts[otherwise if material of item is not flesh]burns[otherwise]chars[end if] away.";
				turn on mentioning hotness;				
				remove the item from play.



Section - Weapons

A damage modifiers rule (this is the heat increases damage rule):
	if the global attacker weapon is hot:
		if the global attacker weapon is not ranged:
			let n be heat strength of the global attacker weapon;
			decrease n by heat resistance of global defender;
			if n greater than 0:
				if the numbers boolean is true, say " + [n] (heat)[run paragraph on]";
				increase the damage modifier by n.

An aftereffects rule (this is the heat can cause weapons to break rule):
	let n be heat strength of the global attacker weapon;
	let m be heat strength of the global defender weapon;
	if n is greater than 0 and global attacker weapon is not ranged:
		if final damage is greater than 0 or defender is at parry:
			if a random chance of n in 50 succeeds:
				turn off mentioning hotness;			
				say "[The global attacker weapon], weakened by being heated, is [bold type]destroyed[roman type]!";
				turn on mentioning hotness;				
				remove global attacker weapon from play;
	if the final damage is less than 0 and the defender is at parry:
		if m is greater than 0:
			if a random chance of n in 50 succeeds:
				turn off mentioning hotness;			
				say "[The global defender weapon], weakened by being heated, is [bold type]destroyed[roman type]!";
				turn on mentioning hotness;				
				remove global defender weapon from play.


Section - Heat resistance

Temp-heat is a number that varies.
The heat resistance rules are a rulebook.

To decide what number is the heat resistance of (guy - a person):
	now test subject is guy;
	now temp-heat is 0;
	consider the heat resistance rules;
	decide on temp-heat.

Heat resistance rule (this is the material heat resistance rule):
	increase temp-heat by destroying heat of the material of the test subject - 1.

A person has a number called the intrinsic heat resistance. The intrinsic heat resistance of a person is usually 0.

Heat resistance rule (this is the intrinsic heat resistance rule):
	increase temp-heat by intrinsic heat resistance of the test subject.

[
Section - Being damaged by hot objects

Every turn when a hot object is enclosed by the location (this is the hot objects deal damage rule):
	repeat with guy running through alive persons enclosed by the location:
		if guy has a hot object:
			let K be a list of things;
			let m be 0;
			repeat with item running through things had by guy:
				if item is hot and item is not a readied weapon:
					let n be heat strength of item;
					decrease n by heat resistance of guy;
					if n greater than 0:
						add item to K;
						increase m by n;
			if m is greater than 0:
				decrease health of guy by m;
				turn off mentioning hotness;
				say "Because of [if number of entries in K is not greater than 1]its[otherwise]their[end if] extreme heat, [K with definite articles] deal[if number of entries in K is not greater than 1]s[end if] [m] damage to [the guy][if guy is killed and guy is player], killing you[otherwise if guy is killed], killing it[end if].";
				turn on mentioning hotness.]

Section - Internal heat

A thing has a number called the internal heat. The internal heat of a thing is usually 0.

Definition: a thing (called the item) is internally-heated if the internal heat of item is greater than 0.

When play begins:
	follow the internal heat rule.

Last every turn (this is the internal heat rule):
	repeat with item running through internally-heated things:
		if heat strength of item is less than internal heat of item:
			now heat strength of item is internal heat of item.

Section - Cooling

A thing is either cooler or not cooler. A thing is usually cooler. [If a burn check was made for an item, it will become not cooler than 1, and therefore will not cool down this turn. This stops us from having many repeated messages about something cooling down completely.]

Last every turn (this is the cooling rule):
	repeat with item running through hot not flaming things:
		unless item is not cooler and heat strength of item is 1:
			if heat strength of item is greater than internal heat of item:
				if a random chance of 1 in 2 succeeds:
					decrease heat strength of item by 1;
					if heat strength of item is 0 and item is visible:
						if item is a readied weapon: [EASY way to stop too many messages; but it is what we want??]
							say "[The item] has cooled down completely.";
		now item is cooler.


[
Section - Hot items heat up other items

Every turn (this is the hot things heat up other things rule):
	repeat with item running through hot things enclosed by the location:
		if item is held by a container:
			let X be a random container holding item;
			do the burn check with X and strength heat strength of item;
			repeat with item2 running through things held by X:
				do the burn check with item2 and strength heat strength of item;
		if item is a container:
			repeat with item2 running through things held by item:
				do the burn check with item2 and strength heat strength of item;
		if item is held by a person and item is not a readied weapon:
			let X be a random person holding item;
			repeat with item2 running through things held by X:
				if item2 is not part of X:
					do the burn check with item2 and strength heat strength of item.

To do the burn check with (item - a thing) and strength (n - a number):
	if n is greater than heat strength of item:
		let m be n - heat strength of item;
		if a random chance of m in 3 succeeds and a random chance of 1 in 3 succeeds:
			increase heat strength of item by 1;
			now item is not cooler.
]




Chapter - Rust

Section - The property

A thing is either rusted or not rusted. A thing is usually not rusted.
Understand "rusted" as a thing when the item described is rusted.

Not-mentioning-rust is a truth state that varies. Not-mentioning-rust is false.

To turn off mentioning rust:
	now not-mentioning-rust is true.

To turn on mentioning rust:
	now not-mentioning-rust is false.

Before printing the name of a rusted thing:
	if not-mentioning-rust is false, say "rusted [run paragraph on]".

First attack modifiers rule:
	turn off mentioning rust.

Last attack modifiers rule:
	turn on mentioning rust.

First damage modifiers rule:
	turn off mentioning rust.

Last damage modifiers rule:
	turn on mentioning rust.


Section - Weapon penalty

A damage modifiers rule (this is the rust decreases damage rule):
	if the global attacker weapon is rusted:
		if the numbers boolean is true, say " - 2 (rust)[run paragraph on]";
		decrease the damage modifier by 2.

Section - Rusted monster penalty

A damage modifiers rule (this is the rusted monster decreases damage rule):
	if the global attacker is rusted:
		if the numbers boolean is true, say " - 2 (rust)[run paragraph on]";
		decrease the damage modifier by 2.

An attack modifiers rule (this is the rusted monster decreases attack rule):
	if the global attacker is rusted:
		if the numbers boolean is true, say " - 2 (rust)[run paragraph on]";
		decrease the to-hit modifier by 2.

Chance to win rule (this is the CTW rusted monster penalty rule):
	if the global attacker is rusted:
		decrease the chance-to-win by 2.


Section - Rust spores

A room is either rust-spored or not rust-spored. A room is usually not rust-spored.

Rust spores is a backdrop. Rust spores is everywhere. Rust spores is plural-named. Understand "brown" and "moss" and "spore" as rust spores.

Instead of doing anything with rust spores:
	if the location is not rust-spored:
		say "This place is blessedly free of rust spores.".

Instead of examining rust spores when the location is rust-spored:
	say "These small brown flaked look innocent enough, but they corrode iron faster than one would think possible.".

Instead of taking rust spores when the location is rust-spored:
	say "You attempt to take some of the rust spores, but they are blown out of your hand as you close it.".



Section - Rust spores rust iron items

Every turn (this is the rust spores rust iron rule):
	repeat with place running through rust-spored rooms:
		repeat with item running through iron not rusted things enclosed by place: [iron mentioned for speed]
			unless item is enclosed by a closed container:
				if item can rust:
					if a random chance of 1 in 6 succeeds:
						now item is rusted;
						if player can see item:
							turn off mentioning rust;
							say "As rust spores whirl around the room, [the item] rust[unless item is plural-named][s][end if].";
							turn on mentioning rust.


Section - Rusting rules

The rusting rules are a rulebook.

To decide whether (item - a thing) can rust:
	now test object is item;
	consider the rusting rules;
	if rule failed:
		decide no;
	otherwise:
		decide yes.

A rusting rule (this is the hot items cannot rust rule):
	if heat strength of test object is greater than 1:
		rule fails.

A rusting rule (this is the only iron items can rust rule):
	if material of test object is not iron:
		rule fails.


Section - Spreading of the rust

A room can be either rust-spored-candidate or not rust-spored-candidate.

Every turn when at least one placed room is rust-spored (this is the spread rust spores rule):
	repeat with place running through placed not rust-spored rooms:
		if at least one rust-spored room is adjacent to place:
			if a random chance of 1 in 10 succeeds:
				now place is rust-spored-candidate;
	repeat with place running through rust-spored-candidate rooms:
		now place is rust-spored;
		now place is not rust-spored-candidate;
		if player is enclosed by place:
			say "Clouds of [bold type]rust spores[roman type] drift into the room.".

[Every turn when at least one placed room is fungi-killer (this is the kill the rust spores rule):
	repeat with place running through placed rust-spored fungi-killer rooms:
		now place is not rust-spored;
		if place is location:
			say "All the rust spores blacken and wither.".]



Section - Starting with a rusting room

A dungeon interest rule (this is the add rust to the dungeon rule):
	if a random chance of 1 in 50 succeeds:
		let place be a random placed room;
		now place is rust-spored;
		if generation info is true:
			say "* [Place] is full of rust spores.".

Section - Containers which release rust spores

A container is either rust-releasing or not rust-releasing. A container is usually not rust-releasing.

Every turn when at least one rust-releasing container is not off-stage (this is the rust the contents of rust-releasing containers rule):
	repeat with item running through rust-releasing not off-stage containers:
		if item contains at least one thing:
			repeat with item2 running through things contained by item:
				if item2 can rust:
					now item2 is rusted.

Last report opening a rust-releasing container (called the item):
	now item is not rust-releasing;
	now location is rust-spored;
	say "As you open the container, a large cloud of rust spores drifts out of it.".

[Next rule is "last" because we want to remove treasure packs first.]
Last dungeon finish rule (this is the sometimes containers release rust rule):
	if a random chance of 1 in 10 succeeds:
		if at least one closed openable container is not off-stage:
			let item be a random closed openable  not off-stage container;
			if location of item is placed:
				now item is rust-releasing;
				if generation info is true, say "Made [item] rust-releasing.".





Chapter - Corrosion

[Corrosion does two things: it completely destroys items with a certain chance; and it degrades weapons.]

To corrode (item - a thing):
	if item corrodes:
		if item is visible:
			say "[The item] dissolve[if item is not plural-named]s[end if].";
		remove item from play;
	otherwise if item is a weapon:
		if item corrodes:
			decrease weapon attack bonus of item by 1;
		if item corrodes:
			decrease weapon attack bonus of item by 1;			
		if item corrodes:
			decrease damage die of item by 1;
			if damage die of item is less than 1:
				now damage die of item is 1.


The corroding rules are a rulebook.

To decide whether (item - a thing) corrodes:
	now test object is item;
	consider the corroding rules;
	if rule succeeded:
		decide yes;
	otherwise:
		decide no.

[Two types of resistance: based on the material, and based on the item itself.]

A material has a number called the corrosion resistance. The corrosion resistance of a material is usually 950. [Percentile chance, because we are working with some small probabilities here -- they come up every turn, and get large quickly.]

The corrosion resistance of iron is 995. [200 turns]
The corrosion resistance of silver is 985. [67 turns]
The corrosion resistance of paper is 950. [20 turns]
The corrosion resistance of cloth is 950. [20 turns]
The corrosion resistance of wood is 970. [33 turns]
The corrosion resistance of leather is 980. [50 turns]
The corrosion resistance of flesh is 900. [10 turns]
The corrosion resistance of glass is 999. [1000 turns]
The corrosion resistance of stone is 998. [500 turns]
The corrosion resistance of dragon skin is 1000. [Infinity turns]

A thing has a number called the personal corrosion resistance. The personal corrosion resistance of a thing is usually 0.

A corroding rule (this is the corroding resistances rule):
	let m be the corrosion resistance of the material of test object;
	let n be a random number between 1 and 1000;
	if n is greater than m:
		let m be the personal corrosion resistance of test object;
		let n be a random number between 1 and 1000;
		if n is greater than m:
			rule succeeds.



Chapter - Hidden

A person is either hidden or not hidden. A person is usually not hidden.
A person is either on-the-lookout or not on-the-lookout. A person is usually not on-the-lookout. [Once they have seen you appear from the shadows once, they'll be better at detecting you later.]
A person is either unnaturally aware or not unnaturally aware. [The unnaturally aware always detect you.]
A person is either unnaturally aware follower or not unnaturally aware follower. [An unnaturally aware follower may not detect you, but does know where you are in the dungeon.]

Status rule (this is the hidden status rule):
	if the player is hidden:
		say "You are [bold type]hidden[roman type].[line break][run paragraph on]"

Attack modifiers rule (this is the hidden gives a small attack bonus rule):
	if the global attacker is hidden:
		say " + 2 (hidden)[run paragraph on]";
		increase the to-hit modifier by 2.

First standard_attacker rule (this is the do nothing when all enemies hidden rule):
	let p be false;
	let q be false;
	repeat with X running through all alive persons enclosed by the location:
		if the faction of the global attacker hates the faction of X:
			now p is true;
			if X is not hidden:
				now q is true;
	if p is true and q is false:
		say "[CAP-attacker] [one of]remains unaware of your presence[or]does not notice you[or]does not detect your presence[at random].";
		rule succeeds.
	


An aftereffects rule (this is the attacking breaks hidden rule):
	if the global attacker is the player:
		now the player is not hidden.

The detection probability is a number that varies.
The detection rules are a rulebook.


A starting the combat round rule (this is the possible detection rule):
	if the player is hidden and the player is not the main actor and the faction of the main actor hates the faction of the player:
		now the detection probability is 3; [base chance]
		consider the detection rules;
[		say "TEST: [detection probability].";]
		let n be a random number between 1 and 100;
		if the detection probability is greater than n or the main actor is unnaturally aware:
			now the player is not hidden;
			say "[The main actor] [if main actor is plural-named]have[otherwise]has[end if] detected you!";
			repeat with guy running through visible persons:
				if the faction of guy hates the faction of the player:
					now guy is on-the-lookout.
	
A detection rule (this is the tension increases probability of detection rule):
	increase the detection probability by the tension.

A detection rule (this is the perception probability of detection rule):
	increase the detection probability by the perception of the main actor.

A detection rule (this is the on-the-lookout increases probability of detection rule):
	if the main actor is on-the-lookout:
		increase the detection probability by 7.

A detection rule (this is the blindness decreases probability of detection rule):
	if the main actor is blind:
		decrease the detection probability by 3.

Section - No perceived threat

To decide whether there is no perceived threat for (guy - a person):
	repeat with guy2 running through persons enclosed by the location of guy:
		if the faction of guy hates the faction of guy2:
			if guy2 is not hidden or guy is unnaturally aware:
				decide no;
	decide yes.

Section - Action restrictions when hidden

Check concentrating (this is the cannot concentrate while hidden rule):
	if the player is hidden:
		take no time;
		say "You need all your concentration just to stay hidden." instead.



Chapter - Smoke

A room has a number called the smoke timer.

Every turn (this is the reduce smoke timer rule):
	if the main actor is the player:
		repeat with place running through rooms:
			if smoke timer of place is greater than 0:
				decrease smoke timer of place by 1;
				if smoke timer of place is 4 and player is in place:
					say "The [bold type]smoke[roman type] becomes less thick.";
				if smoke timer of place is 0 and player is in place:
					say "The [bold type]smoke[roman type] disappears completely.".

Clouds of smoke is a backdrop. Clouds of smoke is everywhere. Clouds of smoke is plural-named. Understand "cloud" and "fog" as clouds of smoke.

Instead of doing anything with clouds of smoke when the smoke timer of the location is less than 1:
		say "This place is free of smoke.".

Instead of touching clouds of smoke:
	say "They are insubstantial.".
	
Instead of taking clouds of smoke:
	say "They are insubstantial.".


Instead of examining clouds of smoke when the smoke timer of the location is greater than 0:
	say "The smoke makes it harder to see clearly.".

To decide whether the smoke is thick:
	if smoke timer of the location is greater than 4:
		decide yes;
	decide no.

To decide whether the smoke is thin:
	if smoke timer of the location is greater than 0 and the smoke timer of the location is less than 5:
		decide yes;
	decide no.

A detection rule (this is the smoke lessens probability of detection rule):
	unless main actor is blind:
		if main actor is not eyeless:
			if the smoke is thick:
				decrease the detection probability by 3;
			if the smoke is thin:
				decrease the detection probability by 2.

An attack modifiers rule (this is the thick smoke makes attacking a little harder rule):
	if the smoke is thick:
		unless the global attacker is blind:
			if the global attacker is not eyeless:
				say " - 1 (smoke)[run paragraph on]";
				decrease the to-hit modifier by 1.	

Chance to win rule (this is the CTW smoke penalty rule):
	if the smoke is thick:
		unless the global attacker is blind:
			if the global attacker is not eyeless:
				decrease the chance-to-win by 1.
			
Attack modifiers rule (this is the running is less risky with smoke rule):
	unless the global attacker is blind:
		if the global attacker is not eyeless:
			if the global defender is the player:
				if the player is runner:
					if smoke is thick:
						if the numbers boolean is true, say " - 3 (running covered by smoke)[run paragraph on]";
						decrease the to-hit modifier by 3;
					if smoke is thin:
						if the numbers boolean is true, say " - 2 (running covered by smoke)[run paragraph on]";
						decrease the to-hit modifier by 2.
			
Attack modifiers rule (this is the retreating is less risky with smoke rule):
	unless the global attacker is blind:
		if the global attacker is not eyeless:
			if the global defender is the player:
				if the player is retreater:
					if smoke is thick:
						if the numbers boolean is true, say " - 2 (retreat covered by smoke)[run paragraph on]";
						decrease the to-hit modifier by 2;
					if smoke is thin:
						if the numbers boolean is true, say " - 1 (retreat covered by smoke)[run paragraph on]";
						decrease the to-hit modifier by 1.

A perception test rule (this is the perception penalty of smoke rule): [BUG with chain golem]
	if smoke is thick:
		decrease test score by 2;
		say " - 2 (smoke)[run paragraph on]";
	if smoke is thin:
		decrease test score by 1;
		say " - 1 (smoke)[run paragraph on]".



Chapter - Environmental messages

[currently: smoke and rust spores]

Before printing the locale description of a room (this is the environmental effects rule):
	if the smoke timer of the location is greater than 0:
		say "[if smoke is thick]Thick[otherwise]Thin[end if] [bold type]clouds of smoke[roman type][if location is rust-spored] and tiny brown spores of the [bold type]rust moss[roman type][end if] fill the room.";
	if the location is rust-spored and the smoke timer of the location is less than 1:
		say "The air is full of the tiny brown spores of the [bold type]rust moss[roman type].".


Chapter - Sudden combat reset

[After teleportation, and other sudden move actions of the player, concentration and so on ought to be reset. They work on the location of the player, so should be called _before_ the move.]

The sudden combat reset rules are a rulebook.

A sudden combat reset rule (this is the sudden concentration reset rule):
	repeat with guy running through alive persons enclosed by the location:
		now concentration of guy is 0.

A sudden combat reset rule (this is the at-Normal reset rule):
	now the combat state of the player is at-Normal;


Chapter - Impeded movement

[In some circumstances, you cannot move. This affects stuff like falling into the lava or jumping down the staircase -- though not reading a scroll of teleportation. We make one universal silent check. We are not using it for going, entering and so on: in such cases, we probably want to print special prose. We do check it after the retreat-induced attacks, though, because these may have stopped us from retreating.]

The impeded movement rules are a rulebook.

To decide whether (guy - a person) can move:
	now test subject is the guy;
	consider the impeded movement rules;
	if rule failed:
		decide no;
	decide yes.


Chapter - Forced action

Forced-action is a truth state that varies. Forced-action is false. [When it is true, we don't say anything about a player's motivation. Currently used for the boots of wandering.]

Every turn (this is the remove forced action rule):
	now forced-action is false.

Kerkerkruip Systems ends here.


Chapter - Physical damage reduction

The physical damage reduction rules are a rulebook. [To be used by all physical damage effects which should be stopped by stuff like armour.]

The pdr is a number that varies.

To calculate the pdr for (guy - a person):
	now pdr is 0;
	now test subject is guy;
	consider the physical damage reduction rules.

[Currently implementing a lazy version without text, because of the deadline.]
